<?php

namespace App\Extensions\MarketingBot\System\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\User;

class MarketingDashboardSetting extends Model
{
    protected $table = 'ext_marketing_dashboard_settings';

    protected $fillable = [
        'user_id',
        'widget_visibility',
        'widget_order',
        'shopify_settings',
        'chart_settings',
    ];

    protected $casts = [
        'widget_visibility' => 'array',
        'widget_order' => 'array',
        'shopify_settings' => 'array',
        'chart_settings' => 'array',
    ];

    /**
     * Get the user that owns the settings
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get default widget visibility
     */
    public static function getDefaultVisibility(): array
    {
        return [
            'shopify_banner' => true,
            'shopify_metrics' => true,
            'shopify_revenue_chart' => true,
            'shopify_top_products' => true,
            'marketing_banner' => true,
            'campaign_chart' => true,
            'contact_chart' => true,
            'overview_grid' => true,
            'campaign_list' => true,
        ];
    }

    /**
     * Get default widget order
     */
    public static function getDefaultOrder(): array
    {
        return [
            'shopify_banner',
            'shopify_metrics',
            'marketing_banner',
            'shopify_revenue_chart',
            'shopify_top_products',
            'campaign_chart',
            'contact_chart',
            'overview_grid',
            'campaign_list',
        ];
    }

    /**
     * Get default Shopify settings
     */
    public static function getDefaultShopifySettings(): array
    {
        return [
            'show_revenue' => true,
            'show_orders' => true,
            'show_aov' => true,
            'show_items_sold' => true,
            'top_products_limit' => 5,
            'revenue_chart_days' => 10,
        ];
    }

    /**
     * Check if widget is visible
     */
    public function isWidgetVisible(string $widget): bool
    {
        $visibility = $this->widget_visibility ?? self::getDefaultVisibility();
        return $visibility[$widget] ?? true;
    }

    /**
     * Get widget order
     */
    public function getWidgetOrder(): array
    {
        return $this->widget_order ?? self::getDefaultOrder();
    }
}
